isco88oesch.csv <- read.csv("ISCO88Oesch.csv")

isco88_oesch18 <- function(isco,selfempl,numempl){
    with(isco88oesch.csv,{
        ii <- match(isco,ISCO88)
        oclass <- Oesch[ii]
        oclass[selfempl & numempl >= 10] <- 1
        professional <- oclass %in% c(5,13)
        oclass[professional & selfempl & numempl ==0] <- 2
        not_professional <- oclass %in% c(6:12,14:16)
        oclass[not_professional & selfempl & numempl %in% 1:9] <- 3
        oclass[not_professional & selfempl & numempl == 0] <- 4
        agrarian <- isco >= 6000 & isco < 7000 | isco >= 9200 & isco <= 9300
        oclass[agrarian & selfempl] <- 17
        oclass[agrarian & !selfempl] <- 18
        oclass
    })
}

isco08oesch.csv <- read.csv("ISCO08Oesch.csv")

isco08_oesch18 <- function(isco,selfempl,numempl){
    with(isco08oesch.csv,{
        ii <- match(isco,ISCO08)
        oclass <- Oesch[ii]
        oclass[selfempl & numempl >= 10] <- 1
        professional <- oclass %in% c(5,13)
        oclass[professional & selfempl & numempl ==0] <- 2
        not_professional <- oclass %in% c(6:12,14:16)
        oclass[not_professional & selfempl & numempl %in% 1:9] <- 3
        oclass[not_professional & selfempl & numempl == 0] <- 4
        agrarian <- isco >= 6000 & isco < 7000 | isco >= 9200 & isco <= 9300
        oclass[agrarian & selfempl] <- 17
        oclass[agrarian & !selfempl] <- 18
        oclass
    })
}

oesch18_labels <- c(
    "Large employers"                               = 1,
    "Self-employed professionals"                   = 2,
    "Small business owners with employees"          = 3,
    "Small business owners without employees"       = 4,
    "Technical experts"                             = 5,
    "Technicians"                                   = 6,
    "Skilled manual"                                = 7,
    "Low-skilled manual"                            = 8,
    "Higher-grade managers and administrators"      = 9,
    "Lower-grade managers and administrators"       = 10,
    "Skilled clerks"                                = 11,
    "Unskilled clerks"                              = 12,
    "Socio-cultural professionals"                  = 13,
    "Socio-cultural semi-professionals"             = 14,
    "Skilled service"                               = 15,
    "Low-skilled service"                           = 16,
    "Self-employed farmers"                         = 17,
    "Primary sector labourers"                      = 18
)

oesch9_labels <- c(
    "Self-employed professionals and large employers"= 1, 
    "Small business owners"                          = 2, 
    "Technical (semi-)professionals"                 = 3, 
    "Production workers"                             = 4, 
    "(Associate) managers"                           = 5, 
    "Clerks"                                         = 6, 
    "Socio-cultural (semi-)professionals"            = 7, 
    "Service workers"                                = 8,
    "Famers and primary sector labourers"            = 9
)

oesch6_labels <- c(
    "Higher-grade service class"= 1, 
    "Lower-grade service class" = 2, 
    "Small business owners"     = 3, 
    "Skilled workers"           = 4, 
    "Unskilled workers"         = 5,
    "Farmers, primary sector"   = 6
)

oesch18_9 <- function(x){
    recode(x,
           1:2   -> 1,
           3:4   -> 2,
           5:6   -> 3,
           7:8   -> 4,
           9:10  -> 5,
           11:12 -> 6,
           13:14 -> 7,
           15:16 -> 8,
           17:18 -> 9
    )
}

oesch18_6 <- function(x){
    recode(x,
           c(1:2,5,9,13) -> 1,
           c(6,10,14)    -> 2,
           3:4           -> 3,
           c(7,11,15)    -> 4,
           c(8,12,16)    -> 5,
           17:18         -> 6
    )
}
